#ifndef GST_GrammarErrorHandler_h__
#define GST_GrammarErrorHandler_h__

#include <algorithm>
#include <iostream>
#include <iterator>
#include <string>

// spirit seems to use its own phoenix impl.
// Including the <boost/phoenix/*> headers causes redefinition errors and other
// horrible stuff
#include <boost/spirit/include/phoenix_function.hpp>

namespace GST
{
namespace Parsers
{

struct error_handler
{
	// see
	// http://www.boost.org/doc/libs/1_52_0/libs/phoenix/doc/html/phoenix/modules/function.html
	// see
	// http://www.boost.org/doc/libs/1_52_0/libs/utility/utility.htm#result_of
#if BOOST_VERSION > 105500
	typedef void result_type;
#else
	template<typename, typename, typename, typename>
	struct result
	{
		typedef void type;
	};
#endif

	template<class Iterator, class What>
	void operator()(Iterator start,
					Iterator end,
					Iterator err_pos,
					const What &what) const
	{
		std::cerr << "Error! Expecting " << what;
		std::cerr << " around \"";
		std::cerr << std::string(
			err_pos,
			err_pos
				+ std::min(
					std::distance(err_pos, end),
					typename std::iterator_traits<Iterator>::difference_type(
						50)));
		std::cerr << '"' << std::endl;
	}
};

typedef boost::phoenix::function<error_handler> error_handler_func;

} // namespace Parsers
} // namespace GST
#endif // GST_GrammarErrorHandler_h__
